@extends('backoffice.dashboard')

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<style>
    .dir-rtl { direction: rtl; text-align: right; }
    .block-card { border-radius:12px; box-shadow:0 6px 18px rgba(0,0,0,0.06); background:#fff; }
    .block-card-header { padding:20px; border-bottom:1px solid #eee; }
    .block-card-body { padding:20px; }
    .small-muted { color:#6c757d; font-size:.9rem; }
    .room-box { border:1px solid #eee; border-radius:10px; padding:15px; transition:.2s; }
    .room-box:hover { box-shadow:0 4px 15px rgba(0,0,0,0.08); }
    .btn-choose { border-radius:8px; padding:8px; }
    .room-disabled { border: 2px solid #dc3545 !important; background: #ffe5e5 !important; opacity: 0.85;}
    .room-disabled:hover {box-shadow: 0 0 10px rgba(220,53,69,0.6) !important;}
    .btn-disabled {background: #dc3545 !important;border: none;cursor: not-allowed !important;opacity: 0.9;}
    .progress-bar.bg-pink {background-color: #ff6b81;}
    .assigned-rooms .badge {font-size: 0.85rem;}
</style>

<div class="container dir-rtl mt-4">
    <div class="row mt-4">
        <div class="col-lg-9">
            <div class="block-card mb-4">
                    @php
                        $affectations = \App\Models\ReservationChambreTente::where('reservation_id', $reservation->id_reserv)->get();
                        $total_aff_male = $affectations->sum('male_personnes');
                        $total_aff_female = $affectations->sum('female_personnes');
                        $allAssigned = ($total_aff_male >= $male) && ($total_aff_female >= $female);
                    @endphp
                <div class="block-card-header">
                    <div class="row align-items-start">
                        <div class="col-md-6">
                            <h3 class="mb-1">
                                تعيين غرفة للحجز رقم:
                                <strong class="text-danger">{{ $reservation->id_reserv }}</strong>
                            </h3>
                            <div class="small-muted">
                                المركب:
                                <strong>{{ $reservation->auberge->nom }}</strong>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="block-card-body">
                    <div class="mb-4">
                        <p class="mb-1">
                            <strong>تاريخ الوصول:</strong> {{ $reservation->date_arrive }} —
                            <strong>تاريخ المغادرة:</strong> {{ $reservation->date_depart }}
                        </p>
                        <p class="mb-1">
                            <strong>عدد الرجال:</strong> {{ $male }}
                            <strong>عدد النساء:</strong> {{ $female }}
                            <strong>المجموع:</strong> {{ $reservation->nbr_personnes }}
                        </p>
                        <small class="small-muted">اختر غرفة مناسبة من القائمة التالية.</small>
                    </div>
                    <div class="row g-3">
                        @forelse($chambres as $ch)
                        @php
                            $aff = \App\Models\ReservationChambreTente::where('chambre_tente_id',$ch->id_chambre_tente)->sum('total_personnes');
                            $reste = $ch->capacite - $aff;
                        @endphp

                        <div class="col-md-4">
                            <div class="room-box {{ $reste == 0 ? 'room-disabled' : '' }}">

                                <h5 class="mb-2">الغرفة رقم: <strong>{{ $ch->num_chambre }}</strong></h5>
                                <p class="small-muted">الطاقة الإجمالية: {{ $ch->capacite }}</p>
                                <p class="small-muted {{ $reste == 0 ? 'text-danger' : 'text-success' }}">
                                    الطاقة المتبقية: {{ $reste }}
                                </p>

                                @php
                                    $disabledRoom = ($reste == 0) || $allAssigned;
                                @endphp

                                <button class="btn w-100 btn-choose
                                    {{ $disabledRoom ? 'btn-disabled' : 'bg-rgb-primary1 text-white' }}"
                                    {{ $disabledRoom ? 'disabled' : '' }}
                                    onclick="{{ $disabledRoom ? '' : 'showForm('.$ch->id_chambre_tente.')' }}">
                                    اختيار هذه الغرفة
                                </button>

                                <form id="form-{{ $ch->id_chambre_tente }}"
                                      action="{{ route('reservation.assignChambre', $reservation->id_reserv) }}"
                                      method="POST"
                                      class="mt-3 d-none"
                                      data-reste="{{ $reste }}"
                                      onsubmit="return validateForm(this, {{ $male }}, {{ $female }})">

                                    @csrf
                                    <input type="hidden" name="chambre_id" value="{{ $ch->id_chambre_tente }}">

                                    <div class="mb-2">
                                        <label>اختيار الجنس:</label>

                                        @php
                                            $remainMale = $male - $total_aff_male;
                                            $remainFemale = $female - $total_aff_female;
                                            $defaultSex = '';

                                            if ($remainMale == 0 && $remainFemale > 0) {
                                                $defaultSex = 'female';
                                            } elseif ($remainFemale == 0 && $remainMale > 0) {
                                                $defaultSex = 'male';
                                            }
                                        @endphp

                                        <select class="form-control sexe-select"
                                                name="sexe"
                                                onchange="toggleInputs(this)"
                                                data-remaining-male="{{ $remainMale }}"
                                                data-remaining-female="{{ $remainFemale }}">

                                            @if($defaultSex == '')
                                                <option value="">-- اختر --</option>
                                                <option value="male">رجال</option>
                                                <option value="female">نساء</option>
                                            @elseif($defaultSex == 'male')
                                                <option value="male" selected>رجال</option>
                                            @elseif($defaultSex == 'female')
                                                <option value="female" selected>نساء</option>
                                            @endif

                                        </select>
                                    </div>
                                    <div class="mb-2 input-male d-none">
                                        <label>عدد الرجال:</label>
                                        <input type="number" name="male_personnes" class="form-control" min="0" value="0">
                                    </div>

                                    <div class="mb-2 input-female d-none">
                                        <label>عدد النساء:</label>
                                        <input type="number" name="female_personnes" class="form-control" min="0" value="0">
                                    </div>
                                    <button class="btn bg-rgb-primary1 text-white w-100 mt-2">
                                        تأكيد التعيين
                                    </button>
                                </form>
                                <form method="POST" action="{{ route('reservation.removeAffectation', [$reservation->id_reserv, $aff->id]) }}"
      onsubmit="return confirmRemove(event)" style="display:inline;">
    @csrf
    @method('DELETE')
    <button type="submit" class="btn btn-sm btn-outline-danger">إزالة</button>
</form>
                            </div>
                        </div>
                        @empty
                        <div class="col-12 text-center text-danger">
                            لا توجد غرف متاحة حاليا في هذا المركب.
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3">
            <div class="block-card p-3">

                <h5 class="mb-4" style="color:#c51b01;"><i class="la la-list-check me-2"></i>ملخص التعيينات</h5>

                <div class="mb-4 d-flex justify-content-around text-center">
                    <div>
                        <div class="h5" style="color:#1a237e;">{{ $total_aff_male }}/{{ $male }}</div>
                        <small class="small-muted d-block">رجال</small>
                        <div class="progress rounded-pill" style="height: 10px; width: 80px; margin: auto;">
                            <div class="progress-bar" role="progressbar" 
                                style="background-color:#1a237e; width: {{ $total_aff_male / max($male,1) * 100 }}%">
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="h5" style="color:#c51b01;">{{ $total_aff_female }}/{{ $female }}</div>
                        <small class="small-muted d-block">نساء</small>
                        <div class="progress rounded-pill" style="height: 10px; width: 80px; margin: auto;">
                            <div class="progress-bar bg-pink" role="progressbar"
                                style="background-color:#c51b01;width: {{ $total_aff_female / max($female,1) * 100 }}%">
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <h6 class="mb-2" style="color:#c51b01;"><i class="la la-bed me-1"></i>الغرف المعيّنة</h6>
                <div class="assigned-rooms" style="max-height: 400px; overflow-y: auto;">
                    @forelse($affectations as $aff)
                        <div class="mb-2 p-2 rounded shadow-sm d-flex justify-content-between align-items-center bg-light">
                            <div>
                                <strong>الغرفة {{ $aff->chambre->num_chambre ?? 'غير معروف' }}</strong>
                                <div class="small text-muted mt-1">
                                    👨 {{ $aff->male_personnes }} — 👩 {{ $aff->female_personnes }}
                                </div>
                            </div>
                            <span class="btn bg-rgb-primary1 text-white">{{ $aff->total_personnes }}</span>
                        </div>
                    @empty
                        <div class="text-muted text-center py-3">لا توجد تعيينات بعد.</div>
                    @endforelse

                    <div class="text-center mt-3">
                    <a href="{{ route('reservation.index') }}" style="background-color:#1a237e;" class="btn btn-primary w-100">
                        <i class="la la-arrow-right me-1"></i> العودة
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<script>
    function showForm(id) {
        document.querySelectorAll("form[id^='form-']").forEach(f => f.classList.add('d-none'));
        document.getElementById('form-' + id).classList.remove('d-none');
    }
    function toggleInputs(select) {
        let form = select.closest("form");
        let maleRemain = parseInt(select.dataset.remainingMale);
        let femaleRemain = parseInt(select.dataset.remainingFemale);

        let maleInput = form.querySelector(".input-male");
        let femaleInput = form.querySelector(".input-female");

        maleInput.classList.add("d-none");
        femaleInput.classList.add("d-none");

        if (select.value === "male") {
            maleInput.classList.remove("d-none");
            form.male_personnes.max = maleRemain;
        }

        if (select.value === "female") {
            femaleInput.classList.remove("d-none");
            form.female_personnes.max = femaleRemain;
        }
    }
    document.addEventListener("DOMContentLoaded", function () {
        document.querySelectorAll(".sexe-select").forEach(sel => {
            if (sel.value === "male" || sel.value === "female") {
                toggleInputs(sel);
            }
        });
    });

    function validateForm(form, maxMale, maxFemale) {

        let sexe = form.sexe.value;
        let male = parseInt(form.male_personnes?.value || 0);
        let female = parseInt(form.female_personnes?.value || 0);
        let total = male + female;
        let errors = [];

        if (!sexe) errors.push("❗ الرجاء اختيار الجنس");
        if (total === 0) errors.push("❗ الرجاء إدخال عدد الأشخاص");

        let capaciteRestante = parseInt(form.getAttribute("data-reste"));
        if (total > capaciteRestante)
            errors.push("⚠️ العدد يتجاوز الطاقة المتبقية (" + capaciteRestante + ")");

        if (male > maxMale)
            errors.push("⚠️ عدد الرجال يتجاوز العدد المتبقي (" + maxMale + ")");

        if (female > maxFemale)
            errors.push("⚠️ عدد النساء يتجاوز العدد المتبقي (" + maxFemale + ")");

        if (errors.length > 0) {
            Swal.fire({
                icon: 'error',
                title: "خطأ",
                html: errors.join("<br>"),
            });
            return false;
        }

        return true;
    }

    function confirmRemove(e) {
        e.preventDefault();
        const form = e.target;
        Swal.fire({
            title: 'تأكيد الإزالة',
            text: "هل تريد فعلاً إزالة الأشخاص من هذه الغرفة؟",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم، إزالة',
            cancelButtonText: 'إلغاء'
        }).then((res) => {
            if (res.isConfirmed) form.submit();
        });
        return false;
    }

</script>

@endsection
